/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.Outliner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlOutline {
    private Indexer indexer;
    private StringBuilder buffer;

    public HtmlOutline(Indexer indexer) {
        this.indexer = indexer;
    }

    public String generate(String string) throws Exception {
        this.buffer = new StringBuilder(1024);
        List<Outliner.Entry> list = this.indexer.generateOutline(string);
        this.addOutline(list);
        String string2 = this.buffer.toString();
        this.buffer = null;
        return string2;
    }

    private void addOutline(List<Outliner.Entry> list) {
        this.add("<ul>\n");
        for (Outliner.Entry entry : list) {
            this.addEntry(entry);
        }
        this.add("</ul>\n");
    }

    private void addEntry(Outliner.Entry entry) {
        this.add("<li>");
        String string = null;
        switch (entry.getKind()) {
            case FUNCTION: 
            case METHOD: 
            case CONSTRUCTOR: {
                string = "function";
                break;
            }
            case CLASS: {
                string = "type-name";
                break;
            }
            case PARAMETER: {
                string = "parameter";
                break;
            }
            case VARIABLE: 
            case SCOPE: {
                string = "identifier";
            }
        }
        this.add("<a href='#");
        this.add(entry.getQname());
        this.add("'>");
        if (string != null) {
            this.add("<span class='");
            this.add(string);
            this.add("'>");
        }
        this.add(entry.getName());
        if (string != null) {
            this.add("</span>");
        }
        this.add("</a>");
        if (entry.isBranch()) {
            this.addOutline(entry.getChildren());
        }
        this.add("</li>");
    }

    private void add(String string) {
        this.buffer.append(string);
    }
}

